import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Deposit: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Deposit',
        ru: 'Депозит',
        cs: 'Záloha',
    },
    'Download agreement': {
        en: 'Download agreement',
        ru: 'Скачать соглашение',
        cs: '',
    },
    Edit: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Edit',
        ru: 'Редактировать',
        cs: 'Upravit',
    },
    'Finish ride': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Finish ride',
        ru: 'Завершить поездку',
        cs: 'Ukončit jízdu',
    },
    'Start ride': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Start ride',
        ru: 'Начать поездку',
        cs: 'Začněte jízdu',
    },
    'Total amount': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total amount',
        ru: 'Общая сумма',
        cs: 'Celková částka',
    },
    'View booking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'View booking',
        ru: 'Посмотреть аренду',
        cs: 'Zobrazit rezervaci',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
