import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarsScheduleBookingPopup,
    CarsScheduleBookingPopupProps,
} from 'features/CarsSchedulePopup/ui/CarsScheduleBookingPopup/CarsScheduleBookingPopup';

import { UserStatus } from 'entities/User/consts/UserStatus';

const storybookMeta = createStorybookMeta<CarsScheduleBookingPopupProps>({
    title: 'features/CarsSchedulePopup/CarsScheduleBookingPopup',
    component: CarsScheduleBookingPopup,

    parameters: {
        date: new Date('2022-04-29T00:00:00'),
    },

    hermioneSelector: '[role="dialog"]',

    args: {
        isTailHidden: true,

        user: {
            id: 'a17f2905-f992-4121-8542-ab91755325dc',
            first_name: 'Kirill',
            last_name: 'Test',
            status: UserStatus.ACTIVE,
            phone_number: '+79528073034',
            email: '',
        },
    },

    decorators: [withStorybookRouter()],
    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleBookingPopupProps>(CarsScheduleBookingPopup);

export const normal = Template.bind({});
normal.args = {
    offerId: '99be982a-753e-e63b-ad8a-9e4a609bad81',
};

export const inProgressWithComment = Template.bind({});
inProgressWithComment.args = {
    offerId: '387e6eb1-a02a-ea24-1dfe-9a2ac60f7c20',
    user: {
        id: '1e438c6a-fe7f-4831-a724-2e0b605564b6',
        first_name: ' Dina',
        last_name: 'Maslov',
        status: 'onboarding',
        phone_number: '+37060348810',
        email: 'dina.krasnoborod@gmail.com',
    },
};

export const completed = Template.bind({});
completed.args = {
    offerId: '99be982a-753e-e63b-ad8a-9e4a609bad81',
};
completed.parameters = {
    date: new Date('2022-05-10T00:00:00'),
};

export const outdated = Template.bind({});
outdated.args = {
    offerId: '99be982a-753e-e63b-ad8a-9e4a609bad82',
};
outdated.parameters = {
    date: new Date('2022-05-10T00:00:00'),
};

export const outdatedWithoutControls = Template.bind({});
outdatedWithoutControls.args = {
    offerId: '99be982a-753e-e63b-ad8a-9e4a609bad82',
};
outdatedWithoutControls.parameters = {
    date: new Date('2022-05-10T00:00:00'),
    flags: { rental_retiree_flow: true },
};

export const withStart = Template.bind({});
withStart.args = {
    offerId: '99be982a-753e-e63b-ad8a-9e4a609bad81',
};
withStart.parameters = { flags: { rental_retiree_flow: true } };

export const withFinish = Template.bind({});
withFinish.args = {
    offerId: '387e6eb1-a02a-ea24-1dfe-9a2ac60f7c20',
};
withFinish.parameters = { flags: { rental_retiree_flow: true } };
