import * as React from 'react';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarsSchedulePopup,
    CarsSchedulePopupProps,
} from 'features/CarsSchedulePopup/ui/CarsSchedulePopup/CarsSchedulePopup';

import { UserStatus } from 'entities/User/consts/UserStatus';

const storybookMeta = createStorybookMeta<CarsSchedulePopupProps>({
    title: 'features/CarsSchedulePopup',
    component: CarsSchedulePopup,

    hermioneSelector: '[role="dialog"]',

    decorators: [withStorybookRouter()],
    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsSchedulePopupProps>((props) => {
    const itemRef = React.useRef() as React.MutableRefObject<Nullable<HTMLDivElement>>;

    return (
        <>
            <div style={{ height: '40px', width: '300px' }} />

            <CarsSchedulePopup
                {...props}
                referenceRef={itemRef}
            />
        </>
    );
});

export const booking = Template.bind({});
booking.args = {
    offerId: '99be982a-753e-e63b-ad8a-9e4a609bad81',
    user: {
        id: 'a17f2905-f992-4121-8542-ab91755325dc',
        first_name: 'Kirill',
        last_name: 'Test',
        status: UserStatus.ACTIVE,
        phone_number: '+79528073034',
        email: '',
    },
};

export const service = Template.bind({});
service.args = {
    status: 'service',
    tagId: '1aff3df3-a74c-464d-86cd-639981402db6',
};
