import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Comment: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Comment',
        ru: 'Комментарий',
        cs: 'Komentář',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
