import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsSchedulePopupComment,
    CarsSchedulePopupCommentProps,
} from 'features/CarsSchedulePopup/ui/CarsSchedulePopupComment/CarsSchedulePopupComment';

const storybookMeta = createStorybookMeta<CarsSchedulePopupCommentProps>({
    title: 'features/CarsSchedulePopup/CarsSchedulePopupComment',
    component: CarsSchedulePopupComment,

    args: {
        storybookWidth: '432px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsSchedulePopupCommentProps>(CarsSchedulePopupComment);

export const empty = Template.bind({});
empty.args = { comment: undefined };
empty.hermioneSelector = 'html';

export const normal = Template.bind({});
normal.args = {
    comment:
        "Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
};
