import * as React from 'react';
import cn from 'classnames';

import { CarsSchedulePopupDetail } from 'features/CarsSchedulePopup/ui/CarsSchedulePopupDetail/CarsSchedulePopupDetail';

import { i18n } from 'features/CarsSchedulePopup/ui/CarsSchedulePopupComment/CarsSchedulePopupComment.i18n';

import styles from 'features/CarsSchedulePopup/ui/CarsSchedulePopupComment/CarsSchedulePopupComment.css';

export interface CarsSchedulePopupCommentProps {
    className?: string;
    comment: Optional<string>;
}

export const CarsSchedulePopupComment: React.FC<CarsSchedulePopupCommentProps> = function CarsSchedulePopupComment({
    className,
    comment,
}) {
    if (!comment) {
        return null;
    }

    return (
        <CarsSchedulePopupDetail
            className={cn(styles.comment, className)}
            label={i18n('Comment')}
        >
            {comment}
        </CarsSchedulePopupDetail>
    );
};
