import * as React from 'react';
import cn from 'classnames';

import styles from 'features/CarsSchedulePopup/ui/CarsSchedulePopupDetail/CarsSchedulePopupDetail.css';

export interface CarsSchedulePopupDetailProps {
    className?: string;
    label: React.ReactNode;
}

export const CarsSchedulePopupDetail: React.FC<CarsSchedulePopupDetailProps> = function CarsSchedulePopupDetail({
    className,
    label,
    children,
}) {
    return (
        <div className={cn(styles.detail, className)}>
            <h5 className={styles.label}>{label}</h5>

            <div className={styles.content}>{children}</div>
        </div>
    );
};
