import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsSchedulePopupInfo,
    CarsSchedulePopupInfoProps,
} from 'features/CarsSchedulePopup/ui/CarsSchedulePopupInfo/CarsSchedulePopupInfo';

const storybookMeta = createStorybookMeta<CarsSchedulePopupInfoProps>({
    title: 'features/CarsSchedulePopup/CarsSchedulePopupInfo',
    component: CarsSchedulePopupInfo,

    parameters: {
        backgrounds: { default: 'white' },
    },

    args: {
        storybookWidth: '208px',

        date: new Date('2022-01-01T09:00:00'),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsSchedulePopupInfoProps>(CarsSchedulePopupInfo);

export const normal = Template.bind({});

export const partial = Template.bind({});
partial.args = { date: undefined };

export const withChildren = Template.bind({});
withChildren.args = { time: '10:00', children: <div style={{ height: '20px', backgroundColor: 'pink' }} /> };
