import * as React from 'react';
import cn from 'classnames/bind';

import { formatDateTimeString } from 'shared/helpers/formatDateTimeString/formatDateTimeString';

import { i18n } from 'features/CarsSchedulePopup/ui/CarsSchedulePopupInfo/CarsSchedulePopupInfo.i18n';

import styles from 'features/CarsSchedulePopup/ui/CarsSchedulePopupInfo/CarsSchedulePopupInfo.css';

export interface CarsSchedulePopupInfoProps {
    className?: string;
    date: Optional<Date>;
    time?: string;
}

const cx = cn.bind(styles);

export const CarsSchedulePopupInfo: React.FC<CarsSchedulePopupInfoProps> = function CarsSchedulePopupInfo({
    className,
    date,
    time,
    children,
}) {
    return (
        <div className={cn(styles.info, className)}>
            <h5 className={cx(styles.date, { empty: !date })}>
                {date ? formatDateTimeString({ date, time }) : i18n('Not set')}
            </h5>

            {children}
        </div>
    );
};
