import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsSchedulePopupUser,
    CarsSchedulePopupUserProps,
} from 'features/CarsSchedulePopup/ui/CarsSchedulePopupUser/CarsSchedulePopupUser';

import { UserStatus } from 'entities/User/consts/UserStatus';
import { UserShortSchema } from 'entities/User/types/UserShortSchema';

const storybookMeta = createStorybookMeta<CarsSchedulePopupUserProps>({
    title: 'features/CarsSchedulePopup/CarsSchedulePopupUser',
    component: CarsSchedulePopupUser,

    args: {
        storybookWidth: '208px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsSchedulePopupUserProps>(CarsSchedulePopupUser);

const USER: UserShortSchema = {
    id: '123',
    first_name: 'Aleksey',
    last_name: 'Cherenkevich',
    phone_number: '+375336188394',
    email: 'cherenkevich.com@gmail.com',
    status: UserStatus.ACTIVE,
};

export const normal = Template.bind({});
normal.args = { user: USER };

export const long = Template.bind({});
long.args = { user: { ...USER, first_name: 'Aleksey-Aleksey', last_name: 'Cherenkevich-Cherenkevich' } };

export const deleted = Template.bind({});
deleted.args = { user: { ...USER, status: UserStatus.DELETED } };
