import * as React from 'react';

import { getUserFullName } from 'entities/User';
import { UserStatus } from 'entities/User/consts/UserStatus';
import { UserShortSchema } from 'entities/User/types/UserShortSchema';

import { Path } from 'shared/consts/Path';
import { formatPhoneNumber } from 'shared/helpers/formatPhoneNumber/formatPhoneNumber';
import { generateRouterPath } from 'shared/helpers/generateRouterPath/generateRouterPath';
import { Link } from 'shared/ui/Link/Link';

import styles from 'features/CarsSchedulePopup/ui/CarsSchedulePopupUser/CarsSchedulePopupUser.css';

export interface CarsSchedulePopupUserProps {
    user: UserShortSchema;
}

export const CarsSchedulePopupUser: React.FC<CarsSchedulePopupUserProps> = function CarsSchedulePopupUser({ user }) {
    const { id, first_name, last_name, phone_number, status } = user;

    const isDeleted = status === UserStatus.DELETED;

    return (
        <div className={styles.user}>
            <p className={styles.userName}>
                <Link
                    className={styles.link}
                    href={!isDeleted ? generateRouterPath(Path.USER_PROFILE, { id }) : undefined}
                    disabled={isDeleted}
                >
                    {getUserFullName(first_name, last_name)}
                </Link>
            </p>

            <p className={styles.info}>{formatPhoneNumber(phone_number)}</p>
        </div>
    );
};
