import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{value} km': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: '{value} km',
        ru: '{value} км',
        cs: '{value} km',
    },
    Edit: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Edit',
        ru: 'Редактировать',
        cs: 'Upravit',
    },
    Mileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage',
        ru: 'Пробег',
        cs: 'Počet ujetých kilometrů',
    },
    Type: {
        _meta: {
            context: 'Car service job type',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Type',
        ru: 'Тип работ',
        cs: 'Typ',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
