import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarsScheduleServicePopup,
    CarsScheduleServicePopupProps,
} from 'features/CarsSchedulePopup/ui/CarsScheduleServicePopup/CarsScheduleServicePopup';

const storybookMeta = createStorybookMeta<CarsScheduleServicePopupProps>({
    title: 'features/CarsSchedulePopup/CarsScheduleServicePopup',
    component: CarsScheduleServicePopup,

    hermioneSelector: '[role="dialog"]',

    args: {
        isTailHidden: true,
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleServicePopupProps>(CarsScheduleServicePopup);

export const normal = Template.bind({});
normal.args = { tagId: '1aff3df3-a74c-464d-86cd-639981402db6' };

export const withComment = Template.bind({});
withComment.args = { tagId: '983e781c-e769-4b6b-ac44-13ee17aca949' };
