import * as React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { getCarsSchedulePopupTitle } from 'features/CarsSchedulePopup/helpers/getCarsSchedulePopupTitle/getCarsSchedulePopupTitle';
import {
    CarsScheduleBasePopup,
    CarsScheduleBasePopupUIProps,
} from 'features/CarsSchedulePopup/ui/CarsScheduleBasePopup/CarsScheduleBasePopup';
import { CarsSchedulePopupComment } from 'features/CarsSchedulePopup/ui/CarsSchedulePopupComment/CarsSchedulePopupComment';
import { CarsSchedulePopupDetail } from 'features/CarsSchedulePopup/ui/CarsSchedulePopupDetail/CarsSchedulePopupDetail';
import { CarsSchedulePopupInfo } from 'features/CarsSchedulePopup/ui/CarsSchedulePopupInfo/CarsSchedulePopupInfo';

import { getCarServiceJobTypeName } from 'entities/Car';
import { useCarService } from 'entities/Car/api/useCarService/useCarService';
import { CarServiceJobType } from 'entities/Car/consts/CarServiceJobType';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';
import { Button } from 'shared/ui/Button/Button';

import { i18n } from 'features/CarsSchedulePopup/ui/CarsScheduleServicePopup/CarsScheduleServicePopup.i18n';

import EditIcon from 'shared/ui/Icons/images/edit-outline-16.inline.svg';

import styles from 'features/CarsSchedulePopup/ui/CarsScheduleServicePopup/CarsScheduleServicePopup.css';

export interface CarsScheduleServicePopupProps extends CarsScheduleBasePopupUIProps {
    className?: string;
    tagId: string;

    onEdit?(): void;
}

export const CarsScheduleServicePopup = React.forwardRef<HTMLDivElement, CarsScheduleServicePopupProps>(
    function CarsScheduleServicePopup({ className, tagId, onEdit, ...otherProps }, ref) {
        const { data, isLoading } = useCarService(tagId);

        if (!data || isLoading) {
            return null;
        }

        const { since, since_time, until, until_time, job_type, mileage, job_comment } = data;

        return (
            <CarsScheduleBasePopup
                {...otherProps}
                className={className}
                title={getCarsSchedulePopupTitle('service')}
                controls={
                    <Button
                        size={ButtonSize.M}
                        color={ButtonColor.SECONDARY}
                        icon={EditIcon}
                        label={i18n('Edit')}
                        wide
                        onClick={onEdit}
                    />
                }
                ref={ref}
            >
                <div className={styles.content}>
                    <CarsSchedulePopupInfo
                        date={since}
                        time={since_time}
                    />

                    <CarsSchedulePopupInfo
                        date={until}
                        time={until_time}
                    />

                    {job_type && (
                        <CarsSchedulePopupDetail label={i18n('Type')}>
                            {getCarServiceJobTypeName(job_type as CarServiceJobType)}
                        </CarsSchedulePopupDetail>
                    )}

                    {job_type === CarServiceJobType.SCHEDULED_MAINTENANCE && (
                        <CarsSchedulePopupDetail label={i18n('Mileage')}>
                            {mileage ? i18n('{value} km', { value: formatNumber(Number(mileage)) }) : EMPTY_DATA}
                        </CarsSchedulePopupDetail>
                    )}

                    <CarsSchedulePopupComment comment={job_comment} />
                </div>
            </CarsScheduleBasePopup>
        );
    },
);
