import * as React from 'react';
import { useHistory, useLocation } from 'react-router-dom';

import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button, ButtonProps } from 'shared/ui/Button/Button';

import { i18n } from 'features/ClearFilters/ui/ClearFilters/ClearFilters.i18n';

export interface ClearFiltersProps extends Pick<ButtonProps, 'onClick'> {
    className?: string;
    filters?: string[];
}

export const ClearFilters: React.FC<ClearFiltersProps> = function FiltersContainer({ className, filters, onClick }) {
    const location = useLocation();
    const history = useHistory();

    const onClickHandler = React.useCallback(() => {
        if (filters) {
            const searchParams = new URLSearchParams(location?.search);

            filters.forEach((filter) => {
                searchParams.delete(filter);
            });

            history.push(`${location.pathname}?${searchParams}`);
        }
    }, [filters, location]);

    return (
        <Button
            className={className}
            size={ButtonSize.M}
            label={i18n('Clear filters')}
            shadow
            wide
            onClick={onClick || onClickHandler}
        />
    );
};
