import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add to group': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add to group',
        ru: 'Добавить в группу',
        cs: 'Přidat do skupiny',
    },
    'Go to Groups section': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Go to Groups section',
        ru: 'Перейти в раздел «Группы»',
        cs: 'Přejít do části Skupiny',
    },
    'Group created': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Group created',
        ru: 'Группа создана',
        cs: 'Skupina vytvořena',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
