import * as React from 'react';
import { useState } from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Path } from 'shared/consts/Path';
import { Button } from 'shared/ui/Button/Button';

import GroupModal from 'components/Cars/CarsGroups/GroupModal';
import NotificationCenterContext, { addNotification } from 'components/NotificationCenter/store';

import { i18n } from 'features/CreateGroup/ui/CreateGroup/CreateGroup.i18n';

import FolderIcon from 'shared/ui/Icons/images/folder-outline-16.inline.svg';

export interface CreateGroupProps {
    className?: string;
    tagsFilter?: Nullable<string>;
}

export const CreateGroup: React.FC<CreateGroupProps> = function CreateGroup({ className, tagsFilter }) {
    const [isModalOpen, setModalOpen] = useState<boolean>(false);

    const { notificationDispatch } = React.useContext(NotificationCenterContext) || {};

    const onButtonClickHandler = React.useCallback(() => {
        setModalOpen(true);
    }, []);

    const onCloseModalHandler = React.useCallback((success?: boolean) => {
        setModalOpen(false);

        if (success) {
            notificationDispatch(
                addNotification({
                    title: i18n('Group created'),
                    link: {
                        label: i18n('Go to Groups section'),
                        to: Path.CARS_GROUPS,
                    },
                }),
            );
        }
    }, []);

    if (!tagsFilter) {
        return null;
    }

    return (
        <>
            <Button
                className={className}
                color={ButtonColor.SECONDARY}
                size={ButtonSize.M}
                icon={FolderIcon}
                label={i18n('Add to group')}
                onClick={onButtonClickHandler}
            />

            {isModalOpen && (
                <GroupModal
                    onClose={onCloseModalHandler}
                    type="car"
                    conditions={tagsFilter || ''}
                />
            )}
        </>
    );
};
