import * as React from 'react';
import { useState } from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { MetrikaLabel } from 'shared/consts/MetrikaLabel';
import { metrikaLableClick } from 'shared/helpers/metrikaLabelClick/metrikaLableClick';
import { Button } from 'shared/ui/Button/Button';

import CustomizeTableModal from 'components/Cars/CarsSidebar/CustomizeTableButton/CustomizeTableModal';
import { IHeaderInfo } from 'components/ui/Table/types';

import { i18n } from 'features/CustomizeTable/ui/CustomizeTable/CustomizeTable.i18n';

import SettingsIcon from 'shared/ui/Icons/images/settings-16.inline.svg';

export interface CustomizeTableProps {
    className?: string;

    tableType: string;
    headers: IHeaderInfo[];
    defaultColumns: string[];
    requiredColumns: string[];

    filterColumns?(arr: string[]): string[];

    onCloseModal(columns?: string[]): void;
}

export const CustomizeTable: React.FC<CustomizeTableProps> = function CustomizeTable({
    className,
    tableType,
    headers,
    defaultColumns,
    requiredColumns,
    filterColumns,
    onCloseModal,
}) {
    const [isModalOpen, setModalOpen] = useState<boolean>(false);

    const onButtonClickHandler = React.useCallback(() => {
        setModalOpen(true);
    }, []);

    const onModalCloseHandler = React.useCallback((columns?: string[]) => {
        setModalOpen(false);

        metrikaLableClick(MetrikaLabel.CUSTOMIZE_TABLE);

        if (columns) {
            onCloseModal(columns);
        }
    }, []);

    return (
        <>
            <Button
                className={className}
                color={ButtonColor.SECONDARY}
                size={ButtonSize.M}
                icon={SettingsIcon}
                label={i18n('Columns')}
                onClick={onButtonClickHandler}
            />

            {isModalOpen && (
                <CustomizeTableModal
                    tableType={tableType}
                    headers={headers}
                    defaultColumns={defaultColumns}
                    requiredColumns={requiredColumns}
                    filterColumns={filterColumns}
                    onCloseModal={onModalCloseHandler}
                />
            )}
        </>
    );
};
