import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Avg. per day': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Avg. per day',
        ru: 'Сред. в день',
        cs: 'Průměr za den',
    },
    'Driver’s distribution by scoring': {
        en: 'Driver’s distribution by scoring',
        ru: 'Распределение водителей по скорингу',
        cs: '',
    },
    'High risk of accidents': {
        en: 'High risk of accidents',
        ru: 'Высокий риск несчастных случаев',
        cs: '',
    },
    'Median fleet scoring': {
        en: 'Median fleet scoring',
        ru: 'Медиана скоринга',
        cs: '',
    },
    Today: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Today',
        ru: 'Сегодня',
        cs: 'Dnes',
    },
    'Top cars by scoring': {
        en: 'Top cars by scoring',
        ru: 'Лучшие по скорингу',
        cs: '',
    },
    'Worst cars by scoring': {
        en: 'Worst cars by scoring',
        ru: 'Худшие по скорингу',
        cs: '',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
