import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    DashboardFleetScoring,
    DashboardFleetScoringProps,
} from 'features/DashboardFleetScoring/ui/DashboardFleetScoring/DashboardFleetScoring';

import { DateAggregation } from 'shared/consts/DateAggregation';

const storybookMeta = createStorybookMeta<DashboardFleetScoringProps>({
    title: 'features/DashboardFleetScoring/DashboardFleetScoring',
    component: DashboardFleetScoring,

    parameters: {
        date: new Date('2022-04-01'),
    },

    args: {
        storybookWidth: '100vw',
    },

    decorators: [withStorybookRouter()],
    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<DashboardFleetScoringProps>(DashboardFleetScoring);

export const day = Template.bind({});
day.args = {
    aggregationConfig: {
        since: 1654030800,
        until: 1657832399,
        aggregation: DateAggregation.DAY,
    },
};
export const week = Template.bind({});
week.args = {
    aggregationConfig: {
        since: 1648760400,
        until: 1657832399,
        aggregation: DateAggregation.WEEK,
    },
};
export const month = Template.bind({});
month.args = {
    aggregationConfig: {
        since: 1630443600,
        until: 1657832399,
        aggregation: DateAggregation.MONTH,
    },
};
