import * as H from 'history';

import { DownloadSection } from 'features/DownloadXLS/consts/DownloadSection';
import { downloadXLS } from 'features/DownloadXLS/helpers/downloadXLS/downloadXLS';

import { downloadCarTableXLSX } from 'components/Cars/CarsTable/downloadCarTableXLSX';
import { downloadRidesTableXLSX } from 'components/Rides/RidesTable/downloadRidesTableXLSX';
import { downloadSignalsTableXLSX } from 'components/Signals/SignalsTable/downloadSignalsTableXLSX';

import { RequestHelper } from '../../../../../request-helper/src';

export interface DownloadEntityXLSOptions {
    request: RequestHelper;
    section: DownloadSection;
    getData?: (options?: any) => Promise<any>;
    abortGettingData?: () => void;
    location?: H.Location;
}

export const downloadEntityXLS = async (options: DownloadEntityXLSOptions): Promise<Error | void> => {
    const { request, section, getData, abortGettingData, location } = options;
    let table;

    switch (section) {
        case DownloadSection.CARS:
            table = await downloadCarTableXLSX(request, abortGettingData, getData, location);
            break;

        case DownloadSection.RIDES:
            table = await downloadRidesTableXLSX(request, getData);
            break;

        case DownloadSection.SIGNALS:
            table = await downloadSignalsTableXLSX(getData);
            break;
    }

    if (table) {
        downloadXLS(table);
    }
};
