import XLSX from 'xlsx';

import { EMPTY_DATA } from 'constants/constants';

import { IHeaderInfo } from 'components/ui/Table/types';

export interface DownloadTableXLSProps {
    name: string;
    headers: IHeaderInfo[];
    // param 'table' should be array with rows, not columns
    table: Dict<string | number>[];
}

export const downloadXLS = ({ name, headers, table }: DownloadTableXLSProps) => {
    const data = table.map((row) => {
        return headers.map(({ key }) => row?.[key] ?? EMPTY_DATA);
    });

    data.unshift(headers.map(({ displayName }) => displayName));

    const wb = XLSX.utils.book_new();
    const ws = XLSX.utils.aoa_to_sheet(data);

    XLSX.utils.book_append_sheet(wb, ws);
    XLSX.writeFile(wb, name + '.xlsx');
};
