import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Download XLS': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Download XLS',
        ru: 'Скачать XLS',
        cs: 'Stáhnout XLS',
    },
    'Failed to load XLSX': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Failed to load XLSX',
        ru: 'Не удалось загрузить XLSX',
        cs: 'Načtení XLSX se nezdařilo',
    },
    'Try again': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Try again',
        ru: 'Попробовать снова',
        cs: 'Zkuste to znovu',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
