import * as React from 'react';
import { useLocation } from 'react-router-dom';

import { DownloadSection } from 'features/DownloadXLS/consts/DownloadSection';
import { downloadEntityXLS } from 'features/DownloadXLS/helpers/downloadEntityXLS/downloadEntityXLS';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';
import { ShimmerContext } from 'shared/ui/GlobalShimmer/GlobalShimmer';

import NotificationCenterContext, { addNotification } from 'components/NotificationCenter/store';
import { NotificationIconType } from 'components/NotificationCenter/types';
import { SAVE_REPORT_REQUESTS } from 'components/ui/SectionLayout/SectionFiltersSidebar/MetaControlButton/MetaControlSave/request';

import { RequestHelper } from '../../../../../request-helper/src';

import { i18n } from 'features/DownloadXLS/ui/DownloadXLS/DownloadXLS.i18n';

import DownloadIcon from 'shared/ui/Icons/images/download-outline-16.inline.svg';

export interface DownloadXLSProps {
    className?: string;
    section: DownloadSection;

    // @todo: fix types
    getData?(options?: any): Promise<any>;
    onClick?(): void;

    abortGettingData?(): void;
}

export const DownloadXLS: React.FC<DownloadXLSProps> = function DownloadXLS({
    className,
    section,
    getData,
    onClick,
    abortGettingData,
}) {
    // @todo: move to page
    const location = useLocation();

    const request = React.useRef(new RequestHelper({ requestConfigs: SAVE_REPORT_REQUESTS }));

    const { showShimmer } = React.useContext(ShimmerContext);
    const { notificationDispatch } = React.useContext(NotificationCenterContext) || {};

    const onClickHandler = React.useCallback(async () => {
        showShimmer?.(true);

        try {
            if (onClick) {
                await onClick();
            } else {
                await downloadEntityXLS({
                    request: request?.current,
                    section,
                    getData,
                    abortGettingData,
                    location,
                });
            }
        } catch (error) {
            console.error(error);

            notificationDispatch(addNotification(notificationOptions));
        }

        showShimmer?.(false);
    }, [onClick, getData, abortGettingData]);

    const notificationOptions = {
        title: i18n('Failed to load XLSX'),
        iconType: NotificationIconType.ERROR,
        delay: 7000,
        button: {
            label: i18n('Try again'),
            onClick: onClickHandler,
        },
    };

    return (
        <Button
            className={className}
            color={ButtonColor.SECONDARY}
            size={ButtonSize.M}
            icon={DownloadIcon}
            label={i18n('Download XLS')}
            onClick={onClickHandler}
        />
    );
};
