import { HOST_MATCH } from 'constants/constants';

import { ENV } from 'utils/getEnv';
import { getTLD } from 'utils/getTLD';

export function getEnvHost(env: ENV): string {
    const tld = getTLD();

    if (env === ENV.testing || env === ENV.prestable) {
        const origin = location.origin;
        const originMatch = origin.match(HOST_MATCH);
        const envMatch = originMatch?.[2];

        if (envMatch) {
            return origin.replace(envMatch, env);
        }

        return `https://${env}.drivematics.yandex.${tld}`;
    }

    return 'https://drivematics.yandex.' + tld;
}
