import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Prestable: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Prestable',
        ru: 'Престейбл',
        cs: 'Prestabilní',
    },
    Production: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Production',
        ru: 'Прод',
        cs: 'Produkční',
    },
    Testing: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Testing',
        ru: 'Тестинг',
        cs: 'Testování',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
