import * as React from 'react';

import getEnv, { ENV } from 'utils/getEnv';

import { getEnvHost } from 'features/EnvSwitcher/helpers/getEnvHost/getEnvHost';

import { RadioButton } from 'components/ui/RadioButton';

import { i18n } from 'features/EnvSwitcher/ui/EnvSwitcher/EnvSwitcher.i18n';

export interface EnvSwitcherProps {
    mini?: boolean;
}

export const EnvSwitcher: React.FC<EnvSwitcherProps> = function EnvSwitcher({ mini }) {
    const env = getEnv();

    const onChangeHandler = React.useCallback((env: ENV) => {
        location.href = getEnvHost(env);
    }, []);

    const values = React.useMemo(
        () => [
            { value: ENV.testing, placeholder: i18n('Testing') },
            { value: ENV.prod, placeholder: i18n('Production') },
            { value: ENV.prestable, placeholder: i18n('Prestable') },
        ],

        [],
    );

    return (
        <RadioButton
            fullWidth
            mini={mini}
            secondary={!mini}
            selectedValue={env}
            values={values}
            onChange={onChangeHandler}
        />
    );
};
