import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    From: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'From',
        ru: 'С',
        cs: 'Od',
    },
    To: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'To',
        ru: 'По',
        cs: 'Do',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
