import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Search: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search',
        ru: 'Поиск',
        cs: 'Vyhledávání',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
