import * as React from 'react';
import { useHistory, useLocation } from 'react-router-dom';
import cn from 'classnames';

import { MODAL_OBJECT_TYPE_CGI } from 'constants/constants';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';

import { ModalObjectTypes } from 'components/types';

import { i18n } from 'features/HeaderSearch/ui/HeaderSearch/HeaderSearch.i18n';

import SearchIcon from 'shared/ui/Icons/images/search-16.inline.svg';

import styles from 'features/HeaderSearch/ui/HeaderSearch/HeaderSearch.css';

export interface HeaderSearchProps {
    className?: string;
}

export const HeaderSearch: React.FC<HeaderSearchProps> = function HeaderSearch({ className }) {
    // @todo: move to page
    const location = useLocation();
    const history = useHistory();

    const label = i18n('Search');

    const onClickHandler = React.useCallback(() => {
        const searchParams = new URLSearchParams(location?.search);

        searchParams.set(MODAL_OBJECT_TYPE_CGI, ModalObjectTypes.SEARCH);
        history.push(`${location.pathname}?${searchParams}`);
    }, [location]);

    return (
        <Button
            className={cn(styles.headerSearch, className)}
            color={ButtonColor.SECONDARY}
            size={ButtonSize.M}
            icon={SearchIcon}
            label={label}
            onClick={onClickHandler}
        />
    );
};
