import { NOTIFIER_TELEGRAM_TYPE } from 'features/NotificationsTelegram/consts/constants';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface PostNotifierData {
    botId: string;
    groupName: string;
    groupId: string;
}

export interface PostNotifierReq {
    object: {
        type: string;
        meta: {
            chat: {
                chat_id: string;
            };
            bot: {
                bot_id: string;
            };
        };
        display_name: string;
    };
}

export function postNotifier(data: PostNotifierData, cache?: CacheRequestContext) {
    const req: PostNotifierReq = {
        object: {
            type: NOTIFIER_TELEGRAM_TYPE,
            meta: {
                chat: {
                    chat_id: data.groupId,
                },
                bot: {
                    bot_id: data.botId,
                },
            },
            display_name: data.groupName,
        },
    };

    return fetchRequest<PostNotifierReq, unknown>('/api/leasing/notifiers/add', req, {
        method: 'POST',
        cache,
    });
}
