import { NOTIFIER_TELEGRAM_TYPE } from 'features/NotificationsTelegram/consts/constants';
import { NotifierSchema } from 'features/NotificationsTelegram/types/NotifierSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface UpdateNotifierReq {
    object: {
        type: string;
        meta: {
            chat: {
                chat_id: string;
            };
            bot: {
                bot_id: string;
            };
        };
        display_name: string;
    };
}

export function updateNotifier(data: NotifierSchema, cache?: CacheRequestContext) {
    return fetchRequest<UpdateNotifierReq, unknown>(
        '/api/leasing/notifiers/modify',
        {
            object: {
                ...data,
                type: NOTIFIER_TELEGRAM_TYPE,
            },
        },
        {
            method: 'POST',
            cache,
        },
    );
}
