import { NOTIFIER_TELEGRAM_TYPE } from 'features/NotificationsTelegram/consts/constants';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface UpdateNotifierBotIdData {
    bot_id: string;
    new_bot_id: string;
}

export interface UpdateNotifierBotIdReq {
    type: string;
    bot_id: string;
    new_bot_id: string;
}

export function updateNotifierBotId(data: UpdateNotifierBotIdData, cache?: CacheRequestContext) {
    return fetchRequest<UpdateNotifierBotIdReq, unknown>(
        '/api/leasing/notifiers/modify',
        {
            type: NOTIFIER_TELEGRAM_TYPE,
            ...data,
        },
        {
            method: 'POST',
            cache,
        },
    );
}
