import { NotifierSchema } from 'features/NotificationsTelegram/types/NotifierSchema';

import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';

export interface UseNotifiersListReq {
    type?: string; // example: 'telegram_company'
}

export interface UseNotifiersListServerRes {
    objects: NotifierSchema[];
    bot_ids_orphans: string[];
}

export interface UseNotifiersListRes {
    objects: NotifierSchema[];
    bot_ids_orphans: string[];
}

export function useNotifiersList(data) {
    return useFetchRequest<UseNotifiersListReq, UseNotifiersListRes, UseNotifiersListServerRes>(
        '/api/leasing/notifiers/list',
        data,
    );
}
