import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    "Bot ID doesn't exist": {
        en: "Bot ID doesn't exist",
        ru: 'Бота с таким ID не существует',
        cs: '',
    },
    'Group ID already exist': {
        en: 'Group ID already exist',
        ru: 'Группа с таким ID уже существует',
        cs: '',
    },
    "Group ID doesn't exist": {
        en: "Group ID doesn't exist",
        ru: 'Группы с таким ID не существует',
        cs: '',
    },
    'Group name already exist': {
        en: 'Group name already exist',
        ru: 'Группа с таким названием уже существует',
        cs: '',
    },
    'New Bot ID already exist': {
        en: 'New Bot ID already exist',
        ru: 'Бот с таким ID уже существует',
        cs: '',
    },
    "Notifier doesn't exist": {
        en: "Notifier doesn't exist",
        ru: 'Уведомитель не существует',
        cs: '',
    },
    'Something went wrong': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Something went wrong',
        ru: 'Что-то пошло не так',
        cs: 'Něco se pokazilo',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
