import { FetchError } from 'shared/helpers/fetchRequest/fetchRequest';
import { getFetchErrorMessage } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage';
import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import { i18n } from 'features/NotificationsTelegram/helpers/getNotifierErrorMessage/getNotifierErrorMessage.i18n';

const ERROR_MESSAGE: Dict = {
    'notifiers.already_exist.display_name': i18n('Group name already exist'),
    'notifiers.already_exist.chat_id': i18n('Group ID already exist'),

    'notifiers.incorrect_request.new_bot_id': i18n('New Bot ID already exist'),
    'notifiers.incorrect_request.bot_id': i18n("Bot ID doesn't exist"),
    'notifiers.incorrect_request.name': i18n("Notifier doesn't exist"),
    'notifiers.incorrect_request.chat_id': i18n("Group ID doesn't exist"),
};

export function getNotifierErrorMessage(error: Error): FormErrorSchema {
    if (error instanceof FetchError) {
        const errorCode = error.res?.error_details?.special_info?.error_code;
        const title = error.canceled ? i18n('Something went wrong') : ERROR_MESSAGE[errorCode];

        if (title) {
            return [{ message: ERROR_MESSAGE[errorCode], code: 'message' }];
        }
    }

    return getFetchErrorMessage(error);
}
