import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'bot ID': {
        en: 'bot ID',
        ru: 'ID бота',
        cs: '',
    },
    'Group name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Group name',
        ru: 'Название группы',
        cs: 'Název skupiny',
    },
    ID: {
        en: 'ID',
        ru: 'ID',
        cs: '',
    },
    'Link a group': {
        en: 'Link a group',
        ru: 'Привязать группу',
        cs: '',
    },
    'Link the first group': {
        en: 'Link the first group',
        ru: 'Привяжите первую группу',
        cs: '',
    },
    'Linked groups': {
        en: 'Linked groups',
        ru: 'Связанные группы',
        cs: '',
    },
    'Save changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save changes',
        ru: 'Сохранить изменения',
        cs: 'Uložit změny',
    },
    'Telegram bot ID': {
        en: 'Telegram bot ID',
        ru: 'ID Telegram-бота',
        cs: '',
    },
    'To set up Telegram notifications you have to add a Telegram bot. You can create the bot directly in the Telegram App. The token you need can be found on the setting page of your bot.':
        {
            en: 'To set up Telegram notifications you have to add a Telegram bot. You can create the bot directly in the Telegram App. The token you need can be found on the setting page of your bot.',
            ru: 'Чтобы настроить уведомления Telegram, вам необходимо добавить Telegram-бота. Вы можете создать бота прямо в приложении Telegram. Нужный вам токен можно найти на странице настроек вашего бота.',
            cs: '',
        },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
