import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Back: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Back',
        ru: 'Назад',
        cs: 'Zpět',
    },
    Delete: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete',
        ru: 'Удалить',
        cs: 'Odstranit',
    },
    'Edit group': {
        en: 'Edit group',
        ru: 'Редактировать группу',
        cs: '',
    },
    'Link a group': {
        en: 'Link a group',
        ru: 'Привязать группу',
        cs: '',
    },
    'Link group': {
        en: 'Link group',
        ru: 'Привязать группу',
        cs: '',
    },
    'Save changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save changes',
        ru: 'Сохранить изменения',
        cs: 'Uložit změny',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
