import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Group ID': {
        en: 'Group ID',
        ru: 'ID Группы',
        cs: '',
    },
    'Group name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Group name',
        ru: 'Название группы',
        cs: 'Název skupiny',
    },
    'To get a group ID long-tap on its title.': {
        en: 'To get a group ID long-tap on its title.',
        ru: 'Чтобы получить ID группы сделайте длительное нажатие на заголовок',
        cs: '',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
