import { CarDamagesSchema } from 'entities/Car/model/CarDamagesSchema';

import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';
import { PictureOptions } from 'shared/ui/Picture/Picture';

export interface FetchRentalDamagesData {
    session_id: string;
}

export interface FetchRentalDamagesRes {
    before_ride: PictureOptions[];
    after_ride: PictureOptions[];
}

export interface FetchRentalDamagesServerRes {
    images: Nullable<CarDamagesSchema[]>;
}

function rentalDamagesParser({ images }: FetchRentalDamagesServerRes): FetchRentalDamagesRes {
    let result: FetchRentalDamagesRes = { before_ride: [], after_ride: [] };

    if (images?.length) {
        for (let i = 0; i < images.length; i++) {
            const image = images[i];

            if (image.marker.includes('before_ride')) {
                result.before_ride.push({ src: image.preview_url, title: image.marker });
            } else {
                result.after_ride.push({ src: image.preview_url, title: image.marker });
            }
        }
    }

    return result;
}

export function fetchRentalDamages(sessionId: string) {
    return useFetchRequest<FetchRentalDamagesData, FetchRentalDamagesRes, FetchRentalDamagesServerRes>(
        '/api/leasing/photo/markup/get',
        {
            session_id: sessionId,
        },
        {
            parser: rentalDamagesParser,
        },
    );
}
