import md5 from 'js-md5';
import { v4 as uuidv4 } from 'uuid';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostRentalFeedbackPhoto {
    marker: string;
    md5: string;
    uuid: string;
}

export interface PostRentalFeedbackRegistryData {
    photos: PostRentalFeedbackPhoto[];
    add: Array<Dict>;
    session_id: string;
}

export type PostRentalFeedbackUploadData = File;

// @todo: move to backend
async function generatePhotosMarker(files: File[], prefix: string): Promise<PostRentalFeedbackPhoto[]> {
    let photos: PostRentalFeedbackPhoto[] = [];

    for (let i = 0; i < files.length; i++) {
        const uuid = uuidv4();
        const buffer = await files[i].arrayBuffer();

        photos.push({ marker: `${prefix}_${uuid}`, md5: md5(buffer), uuid });
    }

    return photos;
}

export async function postRentalFeedback(
    files: File[],
    prefix: 'after_ride' | 'before_ride',
    offerId: string,
    userId: string,
) {
    if (files.length) {
        const photos = await generatePhotosMarker(files, prefix);

        await fetchRequest<PostRentalFeedbackRegistryData, unknown>(
            '/api/leasing/sessions/feedback',
            {
                photos,
                add: [
                    {
                        tag: 'ugc_unspecified',
                    },
                ],
                session_id: offerId,
            },
            {
                method: 'POST',
                headers: { UserIdDelegation: userId },
            },
        );

        // @todo: write a queue
        for (let i = 0; i < files.length; i++) {
            const file = files[i];

            await fetchRequest<PostRentalFeedbackUploadData, unknown>('/api/leasing/sessions/upload-photo', file, {
                method: 'POST',
                query: {
                    object_id: offerId,
                    photo_id: photos[i].uuid,
                },
            });
        }
    }
}
