import { postRentalStatus } from 'features/RentalRetiree/api/postRentalStatus/postRentalStatus';

import { postCarRentalForm } from 'entities/Car/api/postCarRentalForm/postCarRentalForm';
import { UseCarOfferRes } from 'entities/Car/api/useCarOffer/useCarOffer';
import { CarOfferFormSchema } from 'entities/Car/types/CarOfferFormSchema';

import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export async function postRentalPayment(
    data: Optional<UseCarOfferRes>,
    offerId: string,
    tagId: string,
    userId: string,
    cache?: CacheRequestContext,
) {
    if (data?.offer.status !== 'paid') {
        await postCarRentalForm(
            { ...data?.offer, status: 'paid' } as CarOfferFormSchema,
            {
                offerId,
                tagId,
                prev: data?.raw!,
            },
            cache,
        );
    }

    await postRentalStatus({ session_id: offerId, tag: 'old_state_acceptance' }, userId, cache);
}
