import { CarOfferStageSchema } from 'entities/Car/types/CarOfferStageSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';
import { ONE_MINUTE } from 'constants/constants';

export interface PostRentalStatusData {
    session_id: string;
    tag: CarOfferStageSchema;
}

export function postRentalStatus(data: PostRentalStatusData, userId: string, cache?: CacheRequestContext) {
    return fetchRequest<PostRentalStatusData, unknown>('/api/leasing/tag/evolve', data, {
        method: 'POST',
        headers: { userIdDelegation: userId },
        cache,
        timeout: ONE_MINUTE,
    });
}
