import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '2 of 4. Download, print and sign the rental agreement': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: '2 of 4. Download, print and sign the rental agreement',
        ru: '2 из 4. Загрузите, распечатайте и подпишите договор аренды',
        cs: '2 ze 4. Stáhněte si, vytiskněte a podepište smlouvu o pronájmu',
    },
    'Confirm agreement was signed': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Confirm agreement was signed',
        ru: 'Подтвердите, что соглашение было подписано',
        cs: 'Potvrďte, že smlouva byla podepsána',
    },
    Download: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Download',
        ru: 'Скачать',
        cs: 'Stáhnout',
    },
    Downloaded: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Downloaded',
        ru: 'Скачан',
        cs: 'Staženo',
    },
    'Rental agreement': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Rental agreement',
        ru: 'Договор аренды',
        cs: 'Nájemní smlouva',
    },
    'Starting the ride manually': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Starting the ride manually',
        ru: 'Запуск поездки вручную',
        cs: 'Ruční spuštění jízdy',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
