import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    RentalRetireeAgreementModal,
    RentalRetireeAgreementModalProps,
} from 'features/RentalRetiree/ui/RentalRetireeAgreementModal/RentalRetireeAgreementModal';

const storybookMeta = createStorybookMeta<RentalRetireeAgreementModalProps>({
    title: 'features/RentalRetiree/RentalRetireeAgreementModal',
    component: RentalRetireeAgreementModal,

    hermioneSelector: '[role="dialog"]',

    args: {
        offerId: 'test',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<RentalRetireeAgreementModalProps>(RentalRetireeAgreementModal);

export const normal = Template.bind({});
normal.hermioneFn = async (browser, selector) => {
    await browser.$('[title="Download"]').click();
    await browser.$('[role="alert"]').waitForDisplayed();

    await browser.assertView('withError', selector);
};
