import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'No photos were uploaded': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No photos were uploaded',
        ru: 'Фотографии не были загружены',
        cs: 'Nebyly nahrány žádné fotografie',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
