import { buildDummyImageInline } from 'tests/storybook/helpers/buildDummyImageInline';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    RentalRetireeCarPhotos,
    RentalRetireeCarPhotosProps,
} from 'features/RentalRetiree/ui/RentalRetireeCarPhotos/RentalRetireeCarPhotos';

const storybookMeta = createStorybookMeta<RentalRetireeCarPhotosProps>({
    title: 'features/RentalRetiree/RentalRetireeCarPhotos',
    component: RentalRetireeCarPhotos,
});

export default storybookMeta;

const Template = createStorybookTemplate<RentalRetireeCarPhotosProps>(RentalRetireeCarPhotos);

export const normal = Template.bind({});
normal.args = {
    images: [
        {
            src: buildDummyImageInline({ origUrl: 'https://vlootkit.com' }),
            title: 'vlootkit.com',
        },
    ],
    onChange: () => {},
};

export const empty = Template.bind({});
empty.args = { isEmpty: true };
