import * as React from 'react';

import { ImagesPreviewUpload, ImagesPreviewUploadProps } from 'shared/ui/ImagesPreviewUpload/ImagesPreviewUpload';

import { i18n } from 'features/RentalRetiree/ui/RentalRetireeCarPhotos/RentalRetireeCarPhotos.i18n';

export interface RentalRetireeCarPhotosProps extends ImagesPreviewUploadProps {
    className?: string;
    isEmpty?: boolean;
}

export const RentalRetireeCarPhotos: React.FC<RentalRetireeCarPhotosProps> = function RentalRetireeCarPhotos({
    className,
    isEmpty,
    ...otherProps
}) {
    if (isEmpty) {
        return <>{i18n('No photos were uploaded')}</>;
    }

    return (
        <ImagesPreviewUpload
            {...otherProps}
            className={className}
            multiple
        />
    );
};
