import * as React from 'react';
import cn from 'classnames';

import {
    RentalRetireeDocumentPreviewItem,
    RentalRetireeDocumentPreviewItemProps,
} from 'features/RentalRetiree/ui/RentalRetireeDocumentPreviewItem/RentalRetireeDocumentPreviewItem';

import { getUserDocumentPhotoData, UseUserDocumentPhotoRes } from 'entities/User';
import { UserPhotoContentTypeSchema } from 'entities/User/types/UserPhotosSchema';

import styles from 'features/RentalRetiree/ui/RentalRetireeDocumentPreview/RentalRetireeDocumentPreview.css';

export interface RentalRetireeDocumentPreviewProps extends Pick<RentalRetireeDocumentPreviewItemProps, 'onChange'> {
    className?: string;
    photos: UseUserDocumentPhotoRes;
    files: Partial<Record<UserPhotoContentTypeSchema, File>>;
}

export const RentalRetireeDocumentPreview: React.FC<RentalRetireeDocumentPreviewProps> =
    function RentalRetireeDocumentPreview({ className, photos, files, onChange }) {
        const items = getUserDocumentPhotoData(photos);

        return (
            <div className={cn(styles.preview, className)}>
                {items.map((item) => {
                    const file = files[item.type];

                    return (
                        <RentalRetireeDocumentPreviewItem
                            {...item}
                            file={file}
                            onChange={onChange}
                            key={item.type}
                        />
                    );
                })}
            </div>
        );
    };
