import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Back: {
        _meta: {
            context: 'User document photo preview',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Back',
        ru: 'Оборотная',
        cs: 'Vzadu',
    },
    Change: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Change',
        ru: 'Изменить',
        cs: '',
    },
    Front: {
        _meta: {
            context: 'User document photo preview',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Front',
        ru: 'Лицевая',
        cs: 'Přední',
    },
    'Page with photo': {
        _meta: {
            context: 'User document photo preview',
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Page with photo',
        ru: 'Разворот с фото',
        cs: 'Stránka s fotografií',
    },
    Selfie: {
        _meta: {
            context: 'User document photo preview',
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Selfie',
        ru: 'Селфи с документом',
        cs: 'Selfie',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
